import sys
from matplotlib import pyplot as plt
import numpy as np

plt.style.use("fivethirtyeight")

ages_x = [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35]
dev_y = [38496, 42000, 46752, 49320, 53200,
         56000, 62316, 64928, 67317, 68748, 73752]
py_dev_y = [45372, 48876, 53850, 57287, 63016,
            65998, 70003, 70000, 71496, 75370, 83640]
js_dev_y = [37810, 43515, 46823, 49293, 53437,
            56373, 62375, 66674, 68745, 68746, 74583]

# create numpry array of indexes
x_indexes = np.arange(len(ages_x)) 

# line plot by default
#plt.plot(ages_x, dev_y, color="#444444", linestyle='--', label="All Devs")

# bar chart plot
# plt.bar(ages_x, dev_y, color="#444444", label="All Devs")

# we can mix various types of charts - simple overlay
# plt.plot(ages_x, py_dev_y, color="#008fd5", label="Py Devs")
# plt.plot(ages_x, js_dev_y, color="#e5ae38", label="JS Devs")

# bars just overwrite eachother
# plt.bar(ages_x, py_dev_y, color="#008fd5", label="Py Devs")
# plt.bar(ages_x, js_dev_y, color="#e5ae38", label="JS Devs")

# add data side by side as bars
# done by adding offsets

# define width of the bar
width = 0.25 

plt.bar(x_indexes-width, dev_y, width=width, color="#444444", label="All Devs")
plt.bar(x_indexes, py_dev_y, width=width, color="#008fd5", label="Py Devs")
plt.bar(x_indexes+width, js_dev_y, width=width, color="#e5ae38", label="JS Devs")

# change labels from indexes to actual age values
plt.xticks(ticks=x_indexes, labels=ages_x)

plt.legend()
plt.title("Median Salary (USD) by Age")
plt.xlabel("Age")
plt.ylabel("Median Salary (USD)")
plt.tight_layout()
plt.show()